#include "GameOver.h"



GameOver::GameOver(sf::RenderWindow* hwnd, Input* input) : Level(hwnd, input)
{
	backgroundTexture.loadFromFile("Assets/Sprites/Levels/Game Over/background.png");	//Load and set the background to the window size
	backgroundSprite.setTexture(&backgroundTexture);
	backgroundSprite.setSize(sf::Vector2f(1024, 768));
}


GameOver::~GameOver()
{
}

void GameOver::handleInput(float dt)
{

}

void GameOver::update(float dt)
{
	if (Timer::setWaitTime(6.0, dt))	//After 6 seconds of showing Game Over, we return to the Main Menu
	{
		currentLevel = Level::QueryLevel(LevelType_MainMenu);
	}
}

void GameOver::render()
{
	window->draw(backgroundSprite);
}
